/*
 * Decompiled with CFR 0.152.
 */
package com.br.mercado.mercado_back.controller;

import com.br.mercado.mercado_back.model.Produto;
import com.br.mercado.mercado_back.service.ProdutoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/produtos"})
public class ProdutoController {
    @Autowired
    private ProdutoService produtoService;

    @PostMapping
    public Produto criar(@RequestBody Produto produto) {
        return this.produtoService.salvar(produto);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Produto> atualizar(@PathVariable Long id, @RequestBody Produto produto) {
        Produto produtoAtualizado = this.produtoService.atualizar(id, produto);
        if (produtoAtualizado != null) {
            return ResponseEntity.ok((Object)produtoAtualizado);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping
    public List<Produto> listar() {
        return this.produtoService.listarTodos();
    }

    @GetMapping(value={"/{id}"})
    public Produto buscar(@PathVariable Long id) {
        return this.produtoService.buscarPorId(id);
    }

    @DeleteMapping(value={"/{id}"})
    public void deletar(@PathVariable Long id) {
        this.produtoService.deletar(id);
    }

    @GetMapping(value={"/codigo/{codigo}"})
    public Produto buscarPorCodigo(@PathVariable Long codigo) {
        return this.produtoService.buscarPorCodigo(codigo);
    }
}

