/*
 * Decompiled with CFR 0.152.
 */
package com.br.mercado.mercado_back.service;

import com.br.mercado.mercado_back.model.Produto;
import com.br.mercado.mercado_back.repository.ProdutoRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProdutoService {
    @Autowired
    private ProdutoRepository produtoRepository;

    public Produto salvar(Produto produto) {
        return (Produto)this.produtoRepository.save((Object)produto);
    }

    public List<Produto> listarTodos() {
        return this.produtoRepository.findAll();
    }

    public Produto buscarPorId(Long id) {
        return this.produtoRepository.findById((Object)id).orElse(null);
    }

    public void deletar(Long id) {
        this.produtoRepository.deleteById((Object)id);
    }

    public Produto buscarPorCodigo(Long codigo) {
        return this.produtoRepository.findByCodigo(codigo).orElse(null);
    }

    public Produto atualizar(Long id, Produto produtoAtualizado) {
        return this.produtoRepository.findById((Object)id).map(produtoExistente -> {
            produtoExistente.setDescricao(produtoAtualizado.getDescricao());
            produtoExistente.setCodigo(produtoAtualizado.getCodigo());
            produtoExistente.setValor(produtoAtualizado.getValor());
            produtoExistente.setValorUnidade(produtoAtualizado.getValorUnidade());
            produtoExistente.setLayout(produtoAtualizado.getLayout());
            return (Produto)this.produtoRepository.save(produtoExistente);
        }).orElse(null);
    }
}

